package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetIpamResourceCidrsResponse(
    nextToken: Option[NextToken] = None,
    ipamResourceCidrs: Option[Iterable[zio.aws.ec2.model.IpamResourceCidr]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse = {
    import GetIpamResourceCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipamResourceCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamResourceCidrs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamResourceCidrsResponse.wrap(buildAwsValue())
}
object GetIpamResourceCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamResourceCidrsResponse =
      zio.aws.ec2.model.GetIpamResourceCidrsResponse(
        nextToken.map(value => value),
        ipamResourceCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def ipamResourceCidrs
        : Option[List[zio.aws.ec2.model.IpamResourceCidr.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamResourceCidrs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamResourceCidr.ReadOnly
    ]] = AwsError.unwrapOptionField("ipamResourceCidrs", ipamResourceCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ) extends zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamResourceCidrs
        : Option[List[zio.aws.ec2.model.IpamResourceCidr.ReadOnly]] = scala
      .Option(impl.ipamResourceCidrs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamResourceCidr.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ): zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly = new Wrapper(impl)
}
