package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetActivityStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetActivityStatus
}
object FleetActivityStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetActivityStatus
  ): zio.aws.ec2.model.FleetActivityStatus = value match {
    case software.amazon.awssdk.services.ec2.model.FleetActivityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetActivityStatus.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.ec2.model.FleetActivityStatus.PENDING_FULFILLMENT =>
      val r = pending_fulfillment
      r
    case software.amazon.awssdk.services.ec2.model.FleetActivityStatus.PENDING_TERMINATION =>
      val r = pending_termination
      r
    case software.amazon.awssdk.services.ec2.model.FleetActivityStatus.FULFILLED =>
      val r = fulfilled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetActivityStatus =
      software.amazon.awssdk.services.ec2.model.FleetActivityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object error extends zio.aws.ec2.model.FleetActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetActivityStatus =
      software.amazon.awssdk.services.ec2.model.FleetActivityStatus.ERROR
  }
  case object pending_fulfillment
      extends zio.aws.ec2.model.FleetActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetActivityStatus =
      software.amazon.awssdk.services.ec2.model.FleetActivityStatus.PENDING_FULFILLMENT
  }
  case object pending_termination
      extends zio.aws.ec2.model.FleetActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetActivityStatus =
      software.amazon.awssdk.services.ec2.model.FleetActivityStatus.PENDING_TERMINATION
  }
  case object fulfilled extends zio.aws.ec2.model.FleetActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetActivityStatus =
      software.amazon.awssdk.services.ec2.model.FleetActivityStatus.FULFILLED
  }
}
