package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableIpamOrganizationAdminAccountResponse(
    success: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse = {
    import EnableIpamOrganizationAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse
      .builder()
      .optionallyWith(success.map(value => value: java.lang.Boolean))(_.success)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly =
    zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse
      .wrap(buildAwsValue())
}
object EnableIpamOrganizationAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse =
      zio.aws.ec2.model
        .EnableIpamOrganizationAdminAccountResponse(success.map(value => value))
    def success: Option[Boolean]
    def getSuccess: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("success", success)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse
  ) extends zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly {
    override val success: Option[Boolean] =
      scala.Option(impl.success()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse
  ): zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
