package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ElasticGpuState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ElasticGpuState
}
object ElasticGpuState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ElasticGpuState
  ): zio.aws.ec2.model.ElasticGpuState = value match {
    case software.amazon.awssdk.services.ec2.model.ElasticGpuState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ElasticGpuState.ATTACHED =>
      val r = ATTACHED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ElasticGpuState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ElasticGpuState =
      software.amazon.awssdk.services.ec2.model.ElasticGpuState.UNKNOWN_TO_SDK_VERSION
  }
  case object ATTACHED extends zio.aws.ec2.model.ElasticGpuState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ElasticGpuState =
      software.amazon.awssdk.services.ec2.model.ElasticGpuState.ATTACHED
  }
}
