package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsBlockDevice(
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Integer] = None,
    snapshotId: Option[SnapshotId] = None,
    volumeSize: Option[Integer] = None,
    volumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    kmsKeyId: Option[String] = None,
    throughput: Option[Integer] = None,
    outpostArn: Option[String] = None,
    encrypted: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EbsBlockDevice = {
    import EbsBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsBlockDevice
      .builder()
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EbsBlockDevice.ReadOnly =
    zio.aws.ec2.model.EbsBlockDevice.wrap(buildAwsValue())
}
object EbsBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsBlockDevice =
      zio.aws.ec2.model.EbsBlockDevice(
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        kmsKeyId.map(value => value),
        throughput.map(value => value),
        outpostArn.map(value => value),
        encrypted.map(value => value)
      )
    def deleteOnTermination: Option[Boolean]
    def iops: Option[Integer]
    def snapshotId: Option[SnapshotId]
    def volumeSize: Option[Integer]
    def volumeType: Option[zio.aws.ec2.model.VolumeType]
    def kmsKeyId: Option[String]
    def throughput: Option[Integer]
    def outpostArn: Option[String]
    def encrypted: Option[Boolean]
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ) extends zio.aws.ec2.model.EbsBlockDevice.ReadOnly {
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeSize: Option[Integer] =
      scala.Option(impl.volumeSize()).map(value => value: Integer)
    override val volumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val throughput: Option[Integer] =
      scala.Option(impl.throughput()).map(value => value: Integer)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ): zio.aws.ec2.model.EbsBlockDevice.ReadOnly = new Wrapper(impl)
}
