package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateIamInstanceProfileResponse(
    iamInstanceProfileAssociation: Option[
      zio.aws.ec2.model.IamInstanceProfileAssociation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse = {
    import DisassociateIamInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse
      .builder()
      .optionallyWith(
        iamInstanceProfileAssociation.map(value => value.buildAwsValue())
      )(_.iamInstanceProfileAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateIamInstanceProfileResponse
      .wrap(buildAwsValue())
}
object DisassociateIamInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateIamInstanceProfileResponse =
      zio.aws.ec2.model.DisassociateIamInstanceProfileResponse(
        iamInstanceProfileAssociation.map(value => value.asEditable)
      )
    def iamInstanceProfileAssociation
        : Option[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]
    def getIamInstanceProfileAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iamInstanceProfileAssociation",
      iamInstanceProfileAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse
  ) extends zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly {
    override val iamInstanceProfileAssociation
        : Option[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly] =
      scala
        .Option(impl.iamInstanceProfileAssociation())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse
  ): zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
