package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcAttributeResponse(
    vpcId: Option[String] = None,
    enableDnsHostnames: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    enableDnsSupport: Option[zio.aws.ec2.model.AttributeBooleanValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse = {
    import DescribeVpcAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse
      .builder()
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(enableDnsHostnames.map(value => value.buildAwsValue()))(
        _.enableDnsHostnames
      )
      .optionallyWith(enableDnsSupport.map(value => value.buildAwsValue()))(
        _.enableDnsSupport
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcAttributeResponse.wrap(buildAwsValue())
}
object DescribeVpcAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcAttributeResponse =
      zio.aws.ec2.model.DescribeVpcAttributeResponse(
        vpcId.map(value => value),
        enableDnsHostnames.map(value => value.asEditable),
        enableDnsSupport.map(value => value.asEditable)
      )
    def vpcId: Option[String]
    def enableDnsHostnames
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableDnsSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEnableDnsHostnames
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDnsHostnames", enableDnsHostnames)
    def getEnableDnsSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDnsSupport", enableDnsSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse
  ) extends zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly {
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val enableDnsHostnames
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableDnsHostnames())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableDnsSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableDnsSupport())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse
  ): zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly = new Wrapper(impl)
}
