package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VolumeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVolumesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    volumeIds: Option[Iterable[VolumeId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest = {
    import DescribeVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesRequest.wrap(buildAwsValue())
}
object DescribeVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesRequest =
      zio.aws.ec2.model.DescribeVolumesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def volumeIds: Option[List[VolumeId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ) extends zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val volumeIds: Option[List[VolumeId]] = scala
      .Option(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VolumeId(item)
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ): zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly = new Wrapper(impl)
}
