package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeStoreImageTasksRequestMaxResults,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStoreImageTasksRequest(
    imageIds: Option[Iterable[ImageId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeStoreImageTasksRequestMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest = {
    import DescribeStoreImageTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeStoreImageTasksRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeStoreImageTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeStoreImageTasksRequest.wrap(buildAwsValue())
}
object DescribeStoreImageTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeStoreImageTasksRequest =
      zio.aws.ec2.model.DescribeStoreImageTasksRequest(
        imageIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def imageIds: Option[List[ImageId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeStoreImageTasksRequestMaxResults]
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeStoreImageTasksRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest
  ) extends zio.aws.ec2.model.DescribeStoreImageTasksRequest.ReadOnly {
    override val imageIds: Option[List[ImageId]] = scala
      .Option(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeStoreImageTasksRequestMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeStoreImageTasksRequestMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest
  ): zio.aws.ec2.model.DescribeStoreImageTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
