package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    offeringClass: Option[zio.aws.ec2.model.OfferingClassType] = None,
    reservedInstancesIds: Option[Iterable[ReservationId]] = None,
    offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest = {
    import DescribeReservedInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(
        reservedInstancesIds.map(value =>
          value.map { item =>
            ReservationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reservedInstancesIds)
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeReservedInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesRequest.wrap(buildAwsValue())
}
object DescribeReservedInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeReservedInstancesRequest =
      zio.aws.ec2.model.DescribeReservedInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        offeringClass.map(value => value),
        reservedInstancesIds.map(value => value),
        offeringType.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def offeringClass: Option[zio.aws.ec2.model.OfferingClassType]
    def reservedInstancesIds: Option[List[ReservationId]]
    def offeringType: Option[zio.aws.ec2.model.OfferingTypeValues]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getReservedInstancesIds: ZIO[Any, AwsError, List[ReservationId]] =
      AwsError.unwrapOptionField("reservedInstancesIds", reservedInstancesIds)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest
  ) extends zio.aws.ec2.model.DescribeReservedInstancesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val offeringClass: Option[zio.aws.ec2.model.OfferingClassType] =
      scala
        .Option(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val reservedInstancesIds: Option[List[ReservationId]] = scala
      .Option(impl.reservedInstancesIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ReservationId(item)
        }.toList
      )
    override val offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest
  ): zio.aws.ec2.model.DescribeReservedInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
