package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeManagedPrefixListsResponse(
    nextToken: Option[NextToken] = None,
    prefixLists: Option[Iterable[zio.aws.ec2.model.ManagedPrefixList]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse = {
    import DescribeManagedPrefixListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        prefixLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixLists)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeManagedPrefixListsResponse.wrap(buildAwsValue())
}
object DescribeManagedPrefixListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeManagedPrefixListsResponse =
      zio.aws.ec2.model.DescribeManagedPrefixListsResponse(
        nextToken.map(value => value),
        prefixLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def prefixLists: Option[List[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixLists: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ManagedPrefixList.ReadOnly
    ]] = AwsError.unwrapOptionField("prefixLists", prefixLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ) extends zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val prefixLists
        : Option[List[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]] = scala
      .Option(impl.prefixLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ManagedPrefixList.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ): zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly =
    new Wrapper(impl)
}
