package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagesResponse(
    images: Option[Iterable[zio.aws.ec2.model.Image]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImagesResponse = {
    import DescribeImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImagesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImagesResponse.wrap(buildAwsValue())
}
object DescribeImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImagesResponse =
      zio.aws.ec2.model.DescribeImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def images: Option[List[zio.aws.ec2.model.Image.ReadOnly]]
    def getImages: ZIO[Any, AwsError, List[zio.aws.ec2.model.Image.ReadOnly]] =
      AwsError.unwrapOptionField("images", images)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ) extends zio.aws.ec2.model.DescribeImagesResponse.ReadOnly {
    override val images: Option[List[zio.aws.ec2.model.Image.ReadOnly]] = scala
      .Option(impl.images())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Image.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ): zio.aws.ec2.model.DescribeImagesResponse.ReadOnly = new Wrapper(impl)
}
