package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImageAttributeResponse(
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    imageId: Option[String] = None,
    launchPermissions: Option[Iterable[zio.aws.ec2.model.LaunchPermission]] =
      None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    description: Option[zio.aws.ec2.model.AttributeValue] = None,
    kernelId: Option[zio.aws.ec2.model.AttributeValue] = None,
    ramdiskId: Option[zio.aws.ec2.model.AttributeValue] = None,
    sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue] = None,
    bootMode: Option[zio.aws.ec2.model.AttributeValue] = None,
    lastLaunchedTime: Option[zio.aws.ec2.model.AttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse = {
    import DescribeImageAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(
        launchPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchPermissions)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(kernelId.map(value => value.buildAwsValue()))(_.kernelId)
      .optionallyWith(ramdiskId.map(value => value.buildAwsValue()))(
        _.ramdiskId
      )
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(bootMode.map(value => value.buildAwsValue()))(_.bootMode)
      .optionallyWith(lastLaunchedTime.map(value => value.buildAwsValue()))(
        _.lastLaunchedTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImageAttributeResponse.wrap(buildAwsValue())
}
object DescribeImageAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImageAttributeResponse =
      zio.aws.ec2.model.DescribeImageAttributeResponse(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        launchPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value.asEditable),
        kernelId.map(value => value.asEditable),
        ramdiskId.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        bootMode.map(value => value.asEditable),
        lastLaunchedTime.map(value => value.asEditable)
      )
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def imageId: Option[String]
    def launchPermissions
        : Option[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def description: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernelId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def ramdiskId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def bootMode: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def lastLaunchedTime: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getLaunchPermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("launchPermissions", launchPermissions)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getKernelId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getRamdiskId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getBootMode
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getLastLaunchedTime
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("lastLaunchedTime", lastLaunchedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ) extends zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly {
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val launchPermissions
        : Option[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]] = scala
      .Option(impl.launchPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchPermission.wrap(item)
        }.toList
      )
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val description
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.description())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernelId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.kernelId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val ramdiskId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.ramdiskId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sriovNetSupport
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.sriovNetSupport())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val bootMode: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.bootMode())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val lastLaunchedTime
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.lastLaunchedTime())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ): zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
