package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeFpgaImagesMaxResults,
  NextToken,
  FpgaImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFpgaImagesRequest(
    fpgaImageIds: Option[Iterable[FpgaImageId]] = None,
    owners: Option[Iterable[String]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[DescribeFpgaImagesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest = {
    import DescribeFpgaImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
      .builder()
      .optionallyWith(
        fpgaImageIds.map(value =>
          value.map { item =>
            FpgaImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fpgaImageIds)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          DescribeFpgaImagesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFpgaImagesRequest.wrap(buildAwsValue())
}
object DescribeFpgaImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFpgaImagesRequest =
      zio.aws.ec2.model.DescribeFpgaImagesRequest(
        fpgaImageIds.map(value => value),
        owners.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def fpgaImageIds: Option[List[FpgaImageId]]
    def owners: Option[List[String]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[DescribeFpgaImagesMaxResults]
    def getFpgaImageIds: ZIO[Any, AwsError, List[FpgaImageId]] =
      AwsError.unwrapOptionField("fpgaImageIds", fpgaImageIds)
    def getOwners: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("owners", owners)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeFpgaImagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ) extends zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly {
    override val fpgaImageIds: Option[List[FpgaImageId]] = scala
      .Option(impl.fpgaImageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.FpgaImageId(item)
        }.toList
      )
    override val owners: Option[List[String]] = scala
      .Option(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Option[DescribeFpgaImagesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeFpgaImagesMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ): zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly = new Wrapper(impl)
}
