package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterInstanceEventNotificationAttributesRequest(
    instanceTagAttribute: Option[
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest = {
    import DeregisterInstanceEventNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
      .builder()
      .optionallyWith(instanceTagAttribute.map(value => value.buildAwsValue()))(
        _.instanceTagAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object DeregisterInstanceEventNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest =
      zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest(
        instanceTagAttribute.map(value => value.asEditable)
      )
    def instanceTagAttribute: Option[
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly
    ]
    def getInstanceTagAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceTagAttribute", instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ) extends zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly {
    override val instanceTagAttribute: Option[
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly
    ] = scala
      .Option(impl.instanceTagAttribute())
      .map(value =>
        zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ): zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
