package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteVpcPeeringConnectionResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse = {
    import DeleteVpcPeeringConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly =
    zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.wrap(buildAwsValue())
}
object DeleteVpcPeeringConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse =
      zio.aws.ec2.model
        .DeleteVpcPeeringConnectionResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse
  ) extends zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse
  ): zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
