package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateVersionsResponse(
    successfullyDeletedLaunchTemplateVersions: Option[Iterable[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
    ]] = None,
    unsuccessfullyDeletedLaunchTemplateVersions: Option[
      Iterable[zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse = {
    import DeleteLaunchTemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse
      .builder()
      .optionallyWith(
        successfullyDeletedLaunchTemplateVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfullyDeletedLaunchTemplateVersions)
      .optionallyWith(
        unsuccessfullyDeletedLaunchTemplateVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfullyDeletedLaunchTemplateVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.wrap(buildAwsValue())
}
object DeleteLaunchTemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse =
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse(
        successfullyDeletedLaunchTemplateVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfullyDeletedLaunchTemplateVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfullyDeletedLaunchTemplateVersions: Option[List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly
    ]]
    def unsuccessfullyDeletedLaunchTemplateVersions: Option[List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly
    ]]
    def getSuccessfullyDeletedLaunchTemplateVersions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfullyDeletedLaunchTemplateVersions",
      successfullyDeletedLaunchTemplateVersions
    )
    def getUnsuccessfullyDeletedLaunchTemplateVersions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfullyDeletedLaunchTemplateVersions",
      unsuccessfullyDeletedLaunchTemplateVersions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly {
    override val successfullyDeletedLaunchTemplateVersions: Option[List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly
    ]] = scala
      .Option(impl.successfullyDeletedLaunchTemplateVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
            .wrap(item)
        }.toList
      )
    override val unsuccessfullyDeletedLaunchTemplateVersions: Option[List[
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly
    ]] = scala
      .Option(impl.unsuccessfullyDeletedLaunchTemplateVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse
  ): zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
