package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayVpcAttachmentResponse(
    transitGatewayVpcAttachment: Option[
      zio.aws.ec2.model.TransitGatewayVpcAttachment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse = {
    import CreateTransitGatewayVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayVpcAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayVpcAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse =
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse(
        transitGatewayVpcAttachment.map(value => value.asEditable)
      )
    def transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly]
    def getTransitGatewayVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayVpcAttachment",
      transitGatewayVpcAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly {
    override val transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly] = scala
      .Option(impl.transitGatewayVpcAttachment())
      .map(value => zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse
  ): zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
