package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSecurityGroupRequest(
    description: String,
    groupName: String,
    vpcId: Option[VpcId] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest = {
    import CreateSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest
      .builder()
      .description(description: java.lang.String)
      .groupName(groupName: java.lang.String)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSecurityGroupRequest.ReadOnly =
    zio.aws.ec2.model.CreateSecurityGroupRequest.wrap(buildAwsValue())
}
object CreateSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSecurityGroupRequest =
      zio.aws.ec2.model.CreateSecurityGroupRequest(
        description,
        groupName,
        vpcId.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: String
    def groupName: String
    def vpcId: Option[VpcId]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(groupName)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest
  ) extends zio.aws.ec2.model.CreateSecurityGroupRequest.ReadOnly {
    override val description: String = impl.description(): String
    override val groupName: String = impl.groupName(): String
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest
  ): zio.aws.ec2.model.CreateSecurityGroupRequest.ReadOnly = new Wrapper(impl)
}
