package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnAuthenticationRequest(
    `type`: Option[zio.aws.ec2.model.ClientVpnAuthenticationType] = None,
    activeDirectory: Option[
      zio.aws.ec2.model.DirectoryServiceAuthenticationRequest
    ] = None,
    mutualAuthentication: Option[
      zio.aws.ec2.model.CertificateAuthenticationRequest
    ] = None,
    federatedAuthentication: Option[
      zio.aws.ec2.model.FederatedAuthenticationRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest = {
    import ClientVpnAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(activeDirectory.map(value => value.buildAwsValue()))(
        _.activeDirectory
      )
      .optionallyWith(mutualAuthentication.map(value => value.buildAwsValue()))(
        _.mutualAuthentication
      )
      .optionallyWith(
        federatedAuthentication.map(value => value.buildAwsValue())
      )(_.federatedAuthentication)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly =
    zio.aws.ec2.model.ClientVpnAuthenticationRequest.wrap(buildAwsValue())
}
object ClientVpnAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnAuthenticationRequest =
      zio.aws.ec2.model.ClientVpnAuthenticationRequest(
        `type`.map(value => value),
        activeDirectory.map(value => value.asEditable),
        mutualAuthentication.map(value => value.asEditable),
        federatedAuthentication.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.ec2.model.ClientVpnAuthenticationType]
    def activeDirectory: Option[
      zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly
    ]
    def mutualAuthentication
        : Option[zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly]
    def federatedAuthentication
        : Option[zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly]
    def getType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnAuthenticationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getActiveDirectory: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("activeDirectory", activeDirectory)
    def getMutualAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("mutualAuthentication", mutualAuthentication)
    def getFederatedAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "federatedAuthentication",
      federatedAuthentication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest
  ) extends zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly {
    override val `type`: Option[zio.aws.ec2.model.ClientVpnAuthenticationType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ec2.model.ClientVpnAuthenticationType.wrap(value))
    override val activeDirectory: Option[
      zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly
    ] = scala
      .Option(impl.activeDirectory())
      .map(value =>
        zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.wrap(value)
      )
    override val mutualAuthentication
        : Option[zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly] =
      scala
        .Option(impl.mutualAuthentication())
        .map(value =>
          zio.aws.ec2.model.CertificateAuthenticationRequest.wrap(value)
        )
    override val federatedAuthentication
        : Option[zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly] =
      scala
        .Option(impl.federatedAuthentication())
        .map(value =>
          zio.aws.ec2.model.FederatedAuthenticationRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest
  ): zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly = new Wrapper(
    impl
  )
}
