package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassicLoadBalancer(name: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer = {
    import ClassicLoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly =
    zio.aws.ec2.model.ClassicLoadBalancer.wrap(buildAwsValue())
}
object ClassicLoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClassicLoadBalancer =
      zio.aws.ec2.model.ClassicLoadBalancer(name.map(value => value))
    def name: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer
  ) extends zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer
  ): zio.aws.ec2.model.ClassicLoadBalancer.ReadOnly = new Wrapper(impl)
}
