package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CapacityReservationOptions(
    usageStrategy: Option[
      zio.aws.ec2.model.FleetCapacityReservationUsageStrategy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationOptions = {
    import CapacityReservationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationOptions
      .builder()
      .optionallyWith(usageStrategy.map(value => value.unwrap))(_.usageStrategy)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationOptions.ReadOnly =
    zio.aws.ec2.model.CapacityReservationOptions.wrap(buildAwsValue())
}
object CapacityReservationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationOptions =
      zio.aws.ec2.model
        .CapacityReservationOptions(usageStrategy.map(value => value))
    def usageStrategy
        : Option[zio.aws.ec2.model.FleetCapacityReservationUsageStrategy]
    def getUsageStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationUsageStrategy
    ] = AwsError.unwrapOptionField("usageStrategy", usageStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationOptions
  ) extends zio.aws.ec2.model.CapacityReservationOptions.ReadOnly {
    override val usageStrategy
        : Option[zio.aws.ec2.model.FleetCapacityReservationUsageStrategy] =
      scala
        .Option(impl.usageStrategy())
        .map(value =>
          zio.aws.ec2.model.FleetCapacityReservationUsageStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationOptions
  ): zio.aws.ec2.model.CapacityReservationOptions.ReadOnly = new Wrapper(impl)
}
