package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservedInstancesListingId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelReservedInstancesListingRequest(
    reservedInstancesListingId: ReservedInstancesListingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest = {
    import CancelReservedInstancesListingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest
      .builder()
      .reservedInstancesListingId(
        ReservedInstancesListingId.unwrap(
          reservedInstancesListingId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelReservedInstancesListingRequest.ReadOnly =
    zio.aws.ec2.model.CancelReservedInstancesListingRequest
      .wrap(buildAwsValue())
}
object CancelReservedInstancesListingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelReservedInstancesListingRequest =
      zio.aws.ec2.model
        .CancelReservedInstancesListingRequest(reservedInstancesListingId)
    def reservedInstancesListingId: ReservedInstancesListingId
    def getReservedInstancesListingId
        : ZIO[Any, Nothing, ReservedInstancesListingId] =
      ZIO.succeed(reservedInstancesListingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest
  ) extends zio.aws.ec2.model.CancelReservedInstancesListingRequest.ReadOnly {
    override val reservedInstancesListingId: ReservedInstancesListingId =
      zio.aws.ec2.model.primitives
        .ReservedInstancesListingId(impl.reservedInstancesListingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest
  ): zio.aws.ec2.model.CancelReservedInstancesListingRequest.ReadOnly =
    new Wrapper(impl)
}
