package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupName,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeSecurityGroupIngressRequest(
    cidrIp: Option[String] = None,
    fromPort: Option[Integer] = None,
    groupId: Option[SecurityGroupId] = None,
    groupName: Option[SecurityGroupName] = None,
    ipPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] = None,
    ipProtocol: Option[String] = None,
    sourceSecurityGroupName: Option[String] = None,
    sourceSecurityGroupOwnerId: Option[String] = None,
    toPort: Option[Integer] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest = {
    import AuthorizeSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest
      .builder()
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        sourceSecurityGroupName.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupName)
      .optionallyWith(
        sourceSecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupOwnerId)
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest.ReadOnly =
    zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest.wrap(buildAwsValue())
}
object AuthorizeSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest =
      zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest(
        cidrIp.map(value => value),
        fromPort.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipProtocol.map(value => value),
        sourceSecurityGroupName.map(value => value),
        sourceSecurityGroupOwnerId.map(value => value),
        toPort.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cidrIp: Option[String]
    def fromPort: Option[Integer]
    def groupId: Option[SecurityGroupId]
    def groupName: Option[SecurityGroupName]
    def ipPermissions: Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def ipProtocol: Option[String]
    def sourceSecurityGroupName: Option[String]
    def sourceSecurityGroupOwnerId: Option[String]
    def toPort: Option[Integer]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getSourceSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceSecurityGroupName", sourceSecurityGroupName)
    def getSourceSecurityGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSecurityGroupOwnerId",
        sourceSecurityGroupOwnerId
      )
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest
  ) extends zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest.ReadOnly {
    override val cidrIp: Option[String] =
      scala.Option(impl.cidrIp()).map(value => value: String)
    override val fromPort: Option[Integer] =
      scala.Option(impl.fromPort()).map(value => value: Integer)
    override val groupId: Option[SecurityGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Option[SecurityGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
    override val ipPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val sourceSecurityGroupName: Option[String] =
      scala.Option(impl.sourceSecurityGroupName()).map(value => value: String)
    override val sourceSecurityGroupOwnerId: Option[String] = scala
      .Option(impl.sourceSecurityGroupOwnerId())
      .map(value => value: String)
    override val toPort: Option[Integer] =
      scala.Option(impl.toPort()).map(value => value: Integer)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest
  ): zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest.ReadOnly =
    new Wrapper(impl)
}
