package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnsuccessfulItem(
    error: Option[zio.aws.ec2.model.UnsuccessfulItemError] = None,
    resourceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnsuccessfulItem = {
    import UnsuccessfulItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnsuccessfulItem
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UnsuccessfulItem.ReadOnly =
    zio.aws.ec2.model.UnsuccessfulItem.wrap(buildAwsValue())
}
object UnsuccessfulItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnsuccessfulItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnsuccessfulItem =
      zio.aws.ec2.model.UnsuccessfulItem(
        error.map(value => value.asEditable),
        resourceId.map(value => value)
      )
    def error: Option[zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly]
    def resourceId: Option[String]
    def getError
        : ZIO[Any, AwsError, zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulItem
  ) extends zio.aws.ec2.model.UnsuccessfulItem.ReadOnly {
    override val error
        : Option[zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.ec2.model.UnsuccessfulItemError.wrap(value))
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulItem
  ): zio.aws.ec2.model.UnsuccessfulItem.ReadOnly = new Wrapper(impl)
}
