package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectOptions(
    protocol: Option[zio.aws.ec2.model.ProtocolValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectOptions = {
    import TransitGatewayConnectOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectOptions
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectOptions.wrap(buildAwsValue())
}
object TransitGatewayConnectOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectOptions =
      zio.aws.ec2.model
        .TransitGatewayConnectOptions(protocol.map(value => value))
    def protocol: Option[zio.aws.ec2.model.ProtocolValue]
    def getProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.ProtocolValue] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectOptions
  ) extends zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly {
    override val protocol: Option[zio.aws.ec2.model.ProtocolValue] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ec2.model.ProtocolValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectOptions
  ): zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly = new Wrapper(impl)
}
