package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficMirrorTarget(
    trafficMirrorTargetId: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    networkLoadBalancerArn: Option[String] = None,
    `type`: Option[zio.aws.ec2.model.TrafficMirrorTargetType] = None,
    description: Option[String] = None,
    ownerId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget = {
    import TrafficMirrorTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
      .builder()
      .optionallyWith(
        trafficMirrorTargetId.map(value => value: java.lang.String)
      )(_.trafficMirrorTargetId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(
        networkLoadBalancerArn.map(value => value: java.lang.String)
      )(_.networkLoadBalancerArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorTarget.wrap(buildAwsValue())
}
object TrafficMirrorTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorTarget =
      zio.aws.ec2.model.TrafficMirrorTarget(
        trafficMirrorTargetId.map(value => value),
        networkInterfaceId.map(value => value),
        networkLoadBalancerArn.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorTargetId: Option[String]
    def networkInterfaceId: Option[String]
    def networkLoadBalancerArn: Option[String]
    def `type`: Option[zio.aws.ec2.model.TrafficMirrorTargetType]
    def description: Option[String]
    def ownerId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkLoadBalancerArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkLoadBalancerArn", networkLoadBalancerArn)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTargetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ) extends zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly {
    override val trafficMirrorTargetId: Option[String] =
      scala.Option(impl.trafficMirrorTargetId()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val networkLoadBalancerArn: Option[String] =
      scala.Option(impl.networkLoadBalancerArn()).map(value => value: String)
    override val `type`: Option[zio.aws.ec2.model.TrafficMirrorTargetType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ec2.model.TrafficMirrorTargetType.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ): zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly = new Wrapper(impl)
}
