package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ThroughResourcesStatementRequest(
    resourceStatement: Option[zio.aws.ec2.model.ResourceStatementRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest = {
    import ThroughResourcesStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest
      .builder()
      .optionallyWith(resourceStatement.map(value => value.buildAwsValue()))(
        _.resourceStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly =
    zio.aws.ec2.model.ThroughResourcesStatementRequest.wrap(buildAwsValue())
}
object ThroughResourcesStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ThroughResourcesStatementRequest =
      zio.aws.ec2.model.ThroughResourcesStatementRequest(
        resourceStatement.map(value => value.asEditable)
      )
    def resourceStatement
        : Option[zio.aws.ec2.model.ResourceStatementRequest.ReadOnly]
    def getResourceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ResourceStatementRequest.ReadOnly
    ] = AwsError.unwrapOptionField("resourceStatement", resourceStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest
  ) extends zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly {
    override val resourceStatement
        : Option[zio.aws.ec2.model.ResourceStatementRequest.ReadOnly] = scala
      .Option(impl.resourceStatement())
      .map(value => zio.aws.ec2.model.ResourceStatementRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest
  ): zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
