package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SnapshotTaskDetail(
    description: Option[String] = None,
    diskImageSize: Option[Double] = None,
    encrypted: Option[Boolean] = None,
    format: Option[String] = None,
    kmsKeyId: Option[String] = None,
    progress: Option[String] = None,
    snapshotId: Option[String] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    url: Option[String] = None,
    userBucket: Option[zio.aws.ec2.model.UserBucketDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail = {
    import SnapshotTaskDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(diskImageSize.map(value => value: java.lang.Double))(
        _.diskImageSize
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly =
    zio.aws.ec2.model.SnapshotTaskDetail.wrap(buildAwsValue())
}
object SnapshotTaskDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotTaskDetail =
      zio.aws.ec2.model.SnapshotTaskDetail(
        description.map(value => value),
        diskImageSize.map(value => value),
        encrypted.map(value => value),
        format.map(value => value),
        kmsKeyId.map(value => value),
        progress.map(value => value),
        snapshotId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Option[String]
    def diskImageSize: Option[Double]
    def encrypted: Option[Boolean]
    def format: Option[String]
    def kmsKeyId: Option[String]
    def progress: Option[String]
    def snapshotId: Option[String]
    def status: Option[String]
    def statusMessage: Option[String]
    def url: Option[String]
    def userBucket: Option[zio.aws.ec2.model.UserBucketDetails.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskImageSize: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("diskImageSize", diskImageSize)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucketDetails.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ) extends zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val diskImageSize: Option[Double] =
      scala.Option(impl.diskImageSize()).map(value => value: Double)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
    override val userBucket
        : Option[zio.aws.ec2.model.UserBucketDetails.ReadOnly] = scala
      .Option(impl.userBucket())
      .map(value => zio.aws.ec2.model.UserBucketDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ): zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly = new Wrapper(impl)
}
