package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  NetworkInterfaceId,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesNetworkInterface(
    associatePublicIpAddress: Option[Boolean] = None,
    deleteOnTermination: Option[Boolean] = None,
    description: Option[String] = None,
    deviceIndex: Option[Integer] = None,
    groups: Option[Iterable[SecurityGroupId]] = None,
    ipv6AddressCount: Option[Integer] = None,
    ipv6Addresses: Option[
      Iterable[zio.aws.ec2.model.ScheduledInstancesIpv6Address]
    ] = None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    privateIpAddress: Option[String] = None,
    privateIpAddressConfigs: Option[
      Iterable[zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig]
    ] = None,
    secondaryPrivateIpAddressCount: Option[Integer] = None,
    subnetId: Option[SubnetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface = {
    import ScheduledInstancesNetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddressConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddressConfigs)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesNetworkInterface.wrap(buildAwsValue())
}
object ScheduledInstancesNetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesNetworkInterface =
      zio.aws.ec2.model.ScheduledInstancesNetworkInterface(
        associatePublicIpAddress.map(value => value),
        deleteOnTermination.map(value => value),
        description.map(value => value),
        deviceIndex.map(value => value),
        groups.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddressConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondaryPrivateIpAddressCount.map(value => value),
        subnetId.map(value => value)
      )
    def associatePublicIpAddress: Option[Boolean]
    def deleteOnTermination: Option[Boolean]
    def description: Option[String]
    def deviceIndex: Option[Integer]
    def groups: Option[List[SecurityGroupId]]
    def ipv6AddressCount: Option[Integer]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly]]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def privateIpAddress: Option[String]
    def privateIpAddressConfigs: Option[
      List[zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly]
    ]
    def secondaryPrivateIpAddressCount: Option[Integer]
    def subnetId: Option[SubnetId]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddressConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "privateIpAddressConfigs",
      privateIpAddressConfigs
    )
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface
  ) extends zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly {
    override val associatePublicIpAddress: Option[Boolean] =
      scala.Option(impl.associatePublicIpAddress()).map(value => value: Boolean)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val deviceIndex: Option[Integer] =
      scala.Option(impl.deviceIndex()).map(value => value: Integer)
    override val groups: Option[List[SecurityGroupId]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val ipv6AddressCount: Option[Integer] =
      scala.Option(impl.ipv6AddressCount()).map(value => value: Integer)
    override val ipv6Addresses: Option[
      List[zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly]
    ] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesIpv6Address.wrap(item)
        }.toList
      )
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val privateIpAddressConfigs: Option[
      List[zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly]
    ] = scala
      .Option(impl.privateIpAddressConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Option[Integer] = scala
      .Option(impl.secondaryPrivateIpAddressCount())
      .map(value => value: Integer)
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface
  ): zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly =
    new Wrapper(impl)
}
