package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstanceRecurrence(
    frequency: Option[String] = None,
    interval: Option[Integer] = None,
    occurrenceDaySet: Option[Iterable[Integer]] = None,
    occurrenceRelativeToEnd: Option[Boolean] = None,
    occurrenceUnit: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence = {
    import ScheduledInstanceRecurrence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence
      .builder()
      .optionallyWith(frequency.map(value => value: java.lang.String))(
        _.frequency
      )
      .optionallyWith(interval.map(value => value: java.lang.Integer))(
        _.interval
      )
      .optionallyWith(
        occurrenceDaySet.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.occurrenceDaySet)
      .optionallyWith(
        occurrenceRelativeToEnd.map(value => value: java.lang.Boolean)
      )(_.occurrenceRelativeToEnd)
      .optionallyWith(occurrenceUnit.map(value => value: java.lang.String))(
        _.occurrenceUnit
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly =
    zio.aws.ec2.model.ScheduledInstanceRecurrence.wrap(buildAwsValue())
}
object ScheduledInstanceRecurrence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstanceRecurrence =
      zio.aws.ec2.model.ScheduledInstanceRecurrence(
        frequency.map(value => value),
        interval.map(value => value),
        occurrenceDaySet.map(value => value),
        occurrenceRelativeToEnd.map(value => value),
        occurrenceUnit.map(value => value)
      )
    def frequency: Option[String]
    def interval: Option[Integer]
    def occurrenceDaySet: Option[List[Integer]]
    def occurrenceRelativeToEnd: Option[Boolean]
    def occurrenceUnit: Option[String]
    def getFrequency: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getOccurrenceDaySet: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("occurrenceDaySet", occurrenceDaySet)
    def getOccurrenceRelativeToEnd: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("occurrenceRelativeToEnd", occurrenceRelativeToEnd)
    def getOccurrenceUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("occurrenceUnit", occurrenceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence
  ) extends zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly {
    override val frequency: Option[String] =
      scala.Option(impl.frequency()).map(value => value: String)
    override val interval: Option[Integer] =
      scala.Option(impl.interval()).map(value => value: Integer)
    override val occurrenceDaySet: Option[List[Integer]] = scala
      .Option(impl.occurrenceDaySet())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val occurrenceRelativeToEnd: Option[Boolean] =
      scala.Option(impl.occurrenceRelativeToEnd()).map(value => value: Boolean)
    override val occurrenceUnit: Option[String] =
      scala.Option(impl.occurrenceUnit()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence
  ): zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly = new Wrapper(impl)
}
