package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RouteTableAssociationState(
    state: Option[zio.aws.ec2.model.RouteTableAssociationStateCode] = None,
    statusMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RouteTableAssociationState = {
    import RouteTableAssociationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RouteTableAssociationState
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RouteTableAssociationState.ReadOnly =
    zio.aws.ec2.model.RouteTableAssociationState.wrap(buildAwsValue())
}
object RouteTableAssociationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RouteTableAssociationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RouteTableAssociationState =
      zio.aws.ec2.model.RouteTableAssociationState(
        state.map(value => value),
        statusMessage.map(value => value)
      )
    def state: Option[zio.aws.ec2.model.RouteTableAssociationStateCode]
    def statusMessage: Option[String]
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.RouteTableAssociationStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociationState
  ) extends zio.aws.ec2.model.RouteTableAssociationState.ReadOnly {
    override val state
        : Option[zio.aws.ec2.model.RouteTableAssociationStateCode] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.RouteTableAssociationStateCode.wrap(value)
      )
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociationState
  ): zio.aws.ec2.model.RouteTableAssociationState.ReadOnly = new Wrapper(impl)
}
