package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResetNetworkInterfaceAttributeRequest(
    networkInterfaceId: NetworkInterfaceId,
    sourceDestCheck: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest = {
    import ResetNetworkInterfaceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.String))(
        _.sourceDestCheck
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest
      .wrap(buildAwsValue())
}
object ResetNetworkInterfaceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest =
      zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest(
        networkInterfaceId,
        sourceDestCheck.map(value => value)
      )
    def networkInterfaceId: NetworkInterfaceId
    def sourceDestCheck: Option[String]
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getSourceDestCheck: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest
  ) extends zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val sourceDestCheck: Option[String] =
      scala.Option(impl.sourceDestCheck()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest
  ): zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
