package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReplaceRootVolumeTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplaceRootVolumeTask(
    replaceRootVolumeTaskId: Option[ReplaceRootVolumeTaskId] = None,
    instanceId: Option[String] = None,
    taskState: Option[zio.aws.ec2.model.ReplaceRootVolumeTaskState] = None,
    startTime: Option[String] = None,
    completeTime: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask = {
    import ReplaceRootVolumeTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
      .builder()
      .optionallyWith(
        replaceRootVolumeTaskId.map(value =>
          ReplaceRootVolumeTaskId.unwrap(value): java.lang.String
        )
      )(_.replaceRootVolumeTaskId)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(taskState.map(value => value.unwrap))(_.taskState)
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(completeTime.map(value => value: java.lang.String))(
        _.completeTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly =
    zio.aws.ec2.model.ReplaceRootVolumeTask.wrap(buildAwsValue())
}
object ReplaceRootVolumeTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRootVolumeTask =
      zio.aws.ec2.model.ReplaceRootVolumeTask(
        replaceRootVolumeTaskId.map(value => value),
        instanceId.map(value => value),
        taskState.map(value => value),
        startTime.map(value => value),
        completeTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replaceRootVolumeTaskId: Option[ReplaceRootVolumeTaskId]
    def instanceId: Option[String]
    def taskState: Option[zio.aws.ec2.model.ReplaceRootVolumeTaskState]
    def startTime: Option[String]
    def completeTime: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getReplaceRootVolumeTaskId
        : ZIO[Any, AwsError, ReplaceRootVolumeTaskId] = AwsError
      .unwrapOptionField("replaceRootVolumeTaskId", replaceRootVolumeTaskId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getTaskState
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReplaceRootVolumeTaskState] =
      AwsError.unwrapOptionField("taskState", taskState)
    def getStartTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompleteTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("completeTime", completeTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ) extends zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly {
    override val replaceRootVolumeTaskId: Option[ReplaceRootVolumeTaskId] =
      scala
        .Option(impl.replaceRootVolumeTaskId())
        .map(value =>
          zio.aws.ec2.model.primitives.ReplaceRootVolumeTaskId(value)
        )
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val taskState
        : Option[zio.aws.ec2.model.ReplaceRootVolumeTaskState] = scala
      .Option(impl.taskState())
      .map(value => zio.aws.ec2.model.ReplaceRootVolumeTaskState.wrap(value))
    override val startTime: Option[String] =
      scala.Option(impl.startTime()).map(value => value: String)
    override val completeTime: Option[String] =
      scala.Option(impl.completeTime()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ): zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly = new Wrapper(impl)
}
