package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, PlacementGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Placement(
    availabilityZone: Option[String] = None,
    affinity: Option[String] = None,
    groupName: Option[PlacementGroupName] = None,
    partitionNumber: Option[Integer] = None,
    hostId: Option[String] = None,
    tenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    spreadDomain: Option[String] = None,
    hostResourceGroupArn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Placement = {
    import Placement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Placement
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(affinity.map(value => value: java.lang.String))(
        _.affinity
      )
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .optionallyWith(hostId.map(value => value: java.lang.String))(_.hostId)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(spreadDomain.map(value => value: java.lang.String))(
        _.spreadDomain
      )
      .optionallyWith(
        hostResourceGroupArn.map(value => value: java.lang.String)
      )(_.hostResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Placement.ReadOnly =
    zio.aws.ec2.model.Placement.wrap(buildAwsValue())
}
object Placement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Placement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Placement = zio.aws.ec2.model.Placement(
      availabilityZone.map(value => value),
      affinity.map(value => value),
      groupName.map(value => value),
      partitionNumber.map(value => value),
      hostId.map(value => value),
      tenancy.map(value => value),
      spreadDomain.map(value => value),
      hostResourceGroupArn.map(value => value)
    )
    def availabilityZone: Option[String]
    def affinity: Option[String]
    def groupName: Option[PlacementGroupName]
    def partitionNumber: Option[Integer]
    def hostId: Option[String]
    def tenancy: Option[zio.aws.ec2.model.Tenancy]
    def spreadDomain: Option[String]
    def hostResourceGroupArn: Option[String]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAffinity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
    def getHostId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getSpreadDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spreadDomain", spreadDomain)
    def getHostResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Placement
  ) extends zio.aws.ec2.model.Placement.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val affinity: Option[String] =
      scala.Option(impl.affinity()).map(value => value: String)
    override val groupName: Option[PlacementGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
    override val partitionNumber: Option[Integer] =
      scala.Option(impl.partitionNumber()).map(value => value: Integer)
    override val hostId: Option[String] =
      scala.Option(impl.hostId()).map(value => value: String)
    override val tenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.tenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val spreadDomain: Option[String] =
      scala.Option(impl.spreadDomain()).map(value => value: String)
    override val hostResourceGroupArn: Option[String] =
      scala.Option(impl.hostResourceGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Placement
  ): zio.aws.ec2.model.Placement.ReadOnly = new Wrapper(impl)
}
