package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    association: Option[zio.aws.ec2.model.NetworkInterfaceAssociation] = None,
    attachment: Option[zio.aws.ec2.model.NetworkInterfaceAttachment] = None,
    availabilityZone: Option[String] = None,
    description: Option[String] = None,
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    interfaceType: Option[zio.aws.ec2.model.NetworkInterfaceType] = None,
    ipv6Addresses: Option[
      Iterable[zio.aws.ec2.model.NetworkInterfaceIpv6Address]
    ] = None,
    macAddress: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    outpostArn: Option[String] = None,
    ownerId: Option[String] = None,
    privateDnsName: Option[String] = None,
    privateIpAddress: Option[String] = None,
    privateIpAddresses: Option[
      Iterable[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress]
    ] = None,
    ipv4Prefixes: Option[Iterable[zio.aws.ec2.model.Ipv4PrefixSpecification]] =
      None,
    ipv6Prefixes: Option[Iterable[zio.aws.ec2.model.Ipv6PrefixSpecification]] =
      None,
    requesterId: Option[String] = None,
    requesterManaged: Option[Boolean] = None,
    sourceDestCheck: Option[Boolean] = None,
    status: Option[zio.aws.ec2.model.NetworkInterfaceStatus] = None,
    subnetId: Option[String] = None,
    tagSet: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vpcId: Option[String] = None,
    denyAllIgwTraffic: Option[Boolean] = None,
    ipv6Native: Option[Boolean] = None,
    ipv6Address: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterface
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(interfaceType.map(value => value.unwrap))(_.interfaceType)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(requesterId.map(value => value: java.lang.String))(
        _.requesterId
      )
      .optionallyWith(requesterManaged.map(value => value: java.lang.Boolean))(
        _.requesterManaged
      )
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(
        tagSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSet)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(denyAllIgwTraffic.map(value => value: java.lang.Boolean))(
        _.denyAllIgwTraffic
      )
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterface.ReadOnly =
    zio.aws.ec2.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterface =
      zio.aws.ec2.model.NetworkInterface(
        association.map(value => value.asEditable),
        attachment.map(value => value.asEditable),
        availabilityZone.map(value => value),
        description.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        interfaceType.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        macAddress.map(value => value),
        networkInterfaceId.map(value => value),
        outpostArn.map(value => value),
        ownerId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requesterId.map(value => value),
        requesterManaged.map(value => value),
        sourceDestCheck.map(value => value),
        status.map(value => value),
        subnetId.map(value => value),
        tagSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value),
        denyAllIgwTraffic.map(value => value),
        ipv6Native.map(value => value),
        ipv6Address.map(value => value)
      )
    def association
        : Option[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly]
    def attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly]
    def availabilityZone: Option[String]
    def description: Option[String]
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def interfaceType: Option[zio.aws.ec2.model.NetworkInterfaceType]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly]]
    def macAddress: Option[String]
    def networkInterfaceId: Option[String]
    def outpostArn: Option[String]
    def ownerId: Option[String]
    def privateDnsName: Option[String]
    def privateIpAddress: Option[String]
    def privateIpAddresses: Option[
      List[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly]
    ]
    def ipv4Prefixes
        : Option[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]]
    def ipv6Prefixes
        : Option[List[zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly]]
    def requesterId: Option[String]
    def requesterManaged: Option[Boolean]
    def sourceDestCheck: Option[Boolean]
    def status: Option[zio.aws.ec2.model.NetworkInterfaceStatus]
    def subnetId: Option[String]
    def tagSet: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Option[String]
    def denyAllIgwTraffic: Option[Boolean]
    def ipv6Native: Option[Boolean]
    def ipv6Address: Option[String]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInterfaceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceType] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getRequesterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterId", requesterId)
    def getRequesterManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterManaged", requesterManaged)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getTagSet: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagSet", tagSet)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDenyAllIgwTraffic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("denyAllIgwTraffic", denyAllIgwTraffic)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterface
  ) extends zio.aws.ec2.model.NetworkInterface.ReadOnly {
    override val association
        : Option[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly] = scala
      .Option(impl.association())
      .map(value => zio.aws.ec2.model.NetworkInterfaceAssociation.wrap(value))
    override val attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.ec2.model.NetworkInterfaceAttachment.wrap(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val interfaceType: Option[zio.aws.ec2.model.NetworkInterfaceType] =
      scala
        .Option(impl.interfaceType())
        .map(value => zio.aws.ec2.model.NetworkInterfaceType.wrap(value))
    override val ipv6Addresses
        : Option[List[zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly]] =
      scala
        .Option(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkInterfaceIpv6Address.wrap(item)
          }.toList
        )
    override val macAddress: Option[String] =
      scala.Option(impl.macAddress()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val privateIpAddresses: Option[
      List[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly]
    ] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.wrap(item)
        }.toList
      )
    override val ipv4Prefixes
        : Option[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]] =
      scala
        .Option(impl.ipv4Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv4PrefixSpecification.wrap(item)
          }.toList
        )
    override val ipv6Prefixes
        : Option[List[zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly]] =
      scala
        .Option(impl.ipv6Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv6PrefixSpecification.wrap(item)
          }.toList
        )
    override val requesterId: Option[String] =
      scala.Option(impl.requesterId()).map(value => value: String)
    override val requesterManaged: Option[Boolean] =
      scala.Option(impl.requesterManaged()).map(value => value: Boolean)
    override val sourceDestCheck: Option[Boolean] =
      scala.Option(impl.sourceDestCheck()).map(value => value: Boolean)
    override val status: Option[zio.aws.ec2.model.NetworkInterfaceStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.NetworkInterfaceStatus.wrap(value))
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val tagSet: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tagSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val denyAllIgwTraffic: Option[Boolean] =
      scala.Option(impl.denyAllIgwTraffic()).map(value => value: Boolean)
    override val ipv6Native: Option[Boolean] =
      scala.Option(impl.ipv6Native()).map(value => value: Boolean)
    override val ipv6Address: Option[String] =
      scala.Option(impl.ipv6Address()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterface
  ): zio.aws.ec2.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
