package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  ResourceArn,
  NetworkInsightsAccessScopeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAccessScope(
    networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId] = None,
    networkInsightsAccessScopeArn: Option[ResourceArn] = None,
    createdDate: Option[MillisecondDateTime] = None,
    updatedDate: Option[MillisecondDateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope = {
    import NetworkInsightsAccessScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(
        networkInsightsAccessScopeArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeArn)
      .optionallyWith(
        createdDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        updatedDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.updatedDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAccessScope.wrap(buildAwsValue())
}
object NetworkInsightsAccessScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAccessScope =
      zio.aws.ec2.model.NetworkInsightsAccessScope(
        networkInsightsAccessScopeId.map(value => value),
        networkInsightsAccessScopeArn.map(value => value),
        createdDate.map(value => value),
        updatedDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId]
    def networkInsightsAccessScopeArn: Option[ResourceArn]
    def createdDate: Option[MillisecondDateTime]
    def updatedDate: Option[MillisecondDateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getNetworkInsightsAccessScopeArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeArn",
        networkInsightsAccessScopeArn
      )
    def getCreatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ) extends zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly {
    override val networkInsightsAccessScopeId
        : Option[NetworkInsightsAccessScopeId] = scala
      .Option(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val networkInsightsAccessScopeArn: Option[ResourceArn] = scala
      .Option(impl.networkInsightsAccessScopeArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val createdDate: Option[MillisecondDateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val updatedDate: Option[MillisecondDateTime] = scala
      .Option(impl.updatedDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ): zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly = new Wrapper(impl)
}
