package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VpnGatewayId,
  CustomerGatewayId,
  TransitGatewayId,
  VpnConnectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionRequest(
    vpnConnectionId: VpnConnectionId,
    transitGatewayId: Option[TransitGatewayId] = None,
    customerGatewayId: Option[CustomerGatewayId] = None,
    vpnGatewayId: Option[VpnGatewayId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest = {
    import ModifyVpnConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        customerGatewayId.map(value =>
          CustomerGatewayId.unwrap(value): java.lang.String
        )
      )(_.customerGatewayId)
      .optionallyWith(
        vpnGatewayId.map(value => VpnGatewayId.unwrap(value): java.lang.String)
      )(_.vpnGatewayId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionRequest.wrap(buildAwsValue())
}
object ModifyVpnConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionRequest =
      zio.aws.ec2.model.ModifyVpnConnectionRequest(
        vpnConnectionId,
        transitGatewayId.map(value => value),
        customerGatewayId.map(value => value),
        vpnGatewayId.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def transitGatewayId: Option[TransitGatewayId]
    def customerGatewayId: Option[CustomerGatewayId]
    def vpnGatewayId: Option[VpnGatewayId]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCustomerGatewayId: ZIO[Any, AwsError, CustomerGatewayId] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getVpnGatewayId: ZIO[Any, AwsError, VpnGatewayId] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ) extends zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val transitGatewayId: Option[TransitGatewayId] = scala
      .Option(impl.transitGatewayId())
      .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val customerGatewayId: Option[CustomerGatewayId] = scala
      .Option(impl.customerGatewayId())
      .map(value => zio.aws.ec2.model.primitives.CustomerGatewayId(value))
    override val vpnGatewayId: Option[VpnGatewayId] = scala
      .Option(impl.vpnGatewayId())
      .map(value => zio.aws.ec2.model.primitives.VpnGatewayId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ): zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly = new Wrapper(impl)
}
