package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateCpuOptions(
    coreCount: Option[Integer] = None,
    threadsPerCore: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions = {
    import LaunchTemplateCpuOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions
      .builder()
      .optionallyWith(coreCount.map(value => value: java.lang.Integer))(
        _.coreCount
      )
      .optionallyWith(threadsPerCore.map(value => value: java.lang.Integer))(
        _.threadsPerCore
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateCpuOptions.wrap(buildAwsValue())
}
object LaunchTemplateCpuOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateCpuOptions =
      zio.aws.ec2.model.LaunchTemplateCpuOptions(
        coreCount.map(value => value),
        threadsPerCore.map(value => value)
      )
    def coreCount: Option[Integer]
    def threadsPerCore: Option[Integer]
    def getCoreCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("coreCount", coreCount)
    def getThreadsPerCore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("threadsPerCore", threadsPerCore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions
  ) extends zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly {
    override val coreCount: Option[Integer] =
      scala.Option(impl.coreCount()).map(value => value: Integer)
    override val threadsPerCore: Option[Integer] =
      scala.Option(impl.threadsPerCore()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions
  ): zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly = new Wrapper(impl)
}
