package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamComplianceStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamComplianceStatus
}
object IpamComplianceStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamComplianceStatus
  ): zio.aws.ec2.model.IpamComplianceStatus = value match {
    case software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.COMPLIANT =>
      val r = compliant
      r
    case software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.NONCOMPLIANT =>
      val r = noncompliant
      r
    case software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.UNMANAGED =>
      val r = unmanaged
      r
    case software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.IGNORED =>
      val r = ignored
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamComplianceStatus =
      software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object compliant extends zio.aws.ec2.model.IpamComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamComplianceStatus =
      software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.COMPLIANT
  }
  case object noncompliant extends zio.aws.ec2.model.IpamComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamComplianceStatus =
      software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.NONCOMPLIANT
  }
  case object unmanaged extends zio.aws.ec2.model.IpamComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamComplianceStatus =
      software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.UNMANAGED
  }
  case object ignored extends zio.aws.ec2.model.IpamComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamComplianceStatus =
      software.amazon.awssdk.services.ec2.model.IpamComplianceStatus.IGNORED
  }
}
