package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceStateChange(
    currentState: Option[zio.aws.ec2.model.InstanceState] = None,
    instanceId: Option[String] = None,
    previousState: Option[zio.aws.ec2.model.InstanceState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStateChange = {
    import InstanceStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStateChange
      .builder()
      .optionallyWith(currentState.map(value => value.buildAwsValue()))(
        _.currentState
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(previousState.map(value => value.buildAwsValue()))(
        _.previousState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStateChange.ReadOnly =
    zio.aws.ec2.model.InstanceStateChange.wrap(buildAwsValue())
}
object InstanceStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStateChange =
      zio.aws.ec2.model.InstanceStateChange(
        currentState.map(value => value.asEditable),
        instanceId.map(value => value),
        previousState.map(value => value.asEditable)
      )
    def currentState: Option[zio.aws.ec2.model.InstanceState.ReadOnly]
    def instanceId: Option[String]
    def previousState: Option[zio.aws.ec2.model.InstanceState.ReadOnly]
    def getCurrentState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("currentState", currentState)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPreviousState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("previousState", previousState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ) extends zio.aws.ec2.model.InstanceStateChange.ReadOnly {
    override val currentState
        : Option[zio.aws.ec2.model.InstanceState.ReadOnly] = scala
      .Option(impl.currentState())
      .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val previousState
        : Option[zio.aws.ec2.model.InstanceState.ReadOnly] = scala
      .Option(impl.previousState())
      .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ): zio.aws.ec2.model.InstanceStateChange.ReadOnly = new Wrapper(impl)
}
