package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.Hour
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowTimeRangeRequest(
    startWeekDay: Option[zio.aws.ec2.model.WeekDay] = None,
    startHour: Option[Hour] = None,
    endWeekDay: Option[zio.aws.ec2.model.WeekDay] = None,
    endHour: Option[Hour] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest = {
    import InstanceEventWindowTimeRangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest
      .builder()
      .optionallyWith(startWeekDay.map(value => value.unwrap))(_.startWeekDay)
      .optionallyWith(startHour.map(value => Hour.unwrap(value): Integer))(
        _.startHour
      )
      .optionallyWith(endWeekDay.map(value => value.unwrap))(_.endWeekDay)
      .optionallyWith(endHour.map(value => Hour.unwrap(value): Integer))(
        _.endHour
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.wrap(buildAwsValue())
}
object InstanceEventWindowTimeRangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest =
      zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest(
        startWeekDay.map(value => value),
        startHour.map(value => value),
        endWeekDay.map(value => value),
        endHour.map(value => value)
      )
    def startWeekDay: Option[zio.aws.ec2.model.WeekDay]
    def startHour: Option[Hour]
    def endWeekDay: Option[zio.aws.ec2.model.WeekDay]
    def endHour: Option[Hour]
    def getStartWeekDay: ZIO[Any, AwsError, zio.aws.ec2.model.WeekDay] =
      AwsError.unwrapOptionField("startWeekDay", startWeekDay)
    def getStartHour: ZIO[Any, AwsError, Hour] =
      AwsError.unwrapOptionField("startHour", startHour)
    def getEndWeekDay: ZIO[Any, AwsError, zio.aws.ec2.model.WeekDay] =
      AwsError.unwrapOptionField("endWeekDay", endWeekDay)
    def getEndHour: ZIO[Any, AwsError, Hour] =
      AwsError.unwrapOptionField("endHour", endHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest
  ) extends zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly {
    override val startWeekDay: Option[zio.aws.ec2.model.WeekDay] = scala
      .Option(impl.startWeekDay())
      .map(value => zio.aws.ec2.model.WeekDay.wrap(value))
    override val startHour: Option[Hour] = scala
      .Option(impl.startHour())
      .map(value => zio.aws.ec2.model.primitives.Hour(value))
    override val endWeekDay: Option[zio.aws.ec2.model.WeekDay] = scala
      .Option(impl.endWeekDay())
      .map(value => zio.aws.ec2.model.WeekDay.wrap(value))
    override val endHour: Option[Hour] = scala
      .Option(impl.endHour())
      .map(value => zio.aws.ec2.model.primitives.Hour(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest
  ): zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly =
    new Wrapper(impl)
}
