package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  GetManagedPrefixListAssociationsMaxResults,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListAssociationsRequest(
    prefixListId: PrefixListResourceId,
    maxResults: Option[GetManagedPrefixListAssociationsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest = {
    import GetManagedPrefixListAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
      .builder()
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          GetManagedPrefixListAssociationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
      .wrap(buildAwsValue())
}
object GetManagedPrefixListAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest =
      zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest(
        prefixListId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def prefixListId: PrefixListResourceId
    def maxResults: Option[GetManagedPrefixListAssociationsMaxResults]
    def nextToken: Option[NextToken]
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getMaxResults
        : ZIO[Any, AwsError, GetManagedPrefixListAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ) extends zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly {
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val maxResults
        : Option[GetManagedPrefixListAssociationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .GetManagedPrefixListAssociationsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ): zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
