package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FpgaImage(
    fpgaImageId: Option[String] = None,
    fpgaImageGlobalId: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    shellVersion: Option[String] = None,
    pciId: Option[zio.aws.ec2.model.PciId] = None,
    state: Option[zio.aws.ec2.model.FpgaImageState] = None,
    createTime: Option[DateTime] = None,
    updateTime: Option[DateTime] = None,
    ownerId: Option[String] = None,
    ownerAlias: Option[String] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    isPublic: Option[Boolean] = None,
    dataRetentionSupport: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FpgaImage = {
    import FpgaImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaImage
      .builder()
      .optionallyWith(fpgaImageId.map(value => value: java.lang.String))(
        _.fpgaImageId
      )
      .optionallyWith(fpgaImageGlobalId.map(value => value: java.lang.String))(
        _.fpgaImageGlobalId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(shellVersion.map(value => value: java.lang.String))(
        _.shellVersion
      )
      .optionallyWith(pciId.map(value => value.buildAwsValue()))(_.pciId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(updateTime.map(value => DateTime.unwrap(value): Instant))(
        _.updateTime
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .optionallyWith(
        dataRetentionSupport.map(value => value: java.lang.Boolean)
      )(_.dataRetentionSupport)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaImage.ReadOnly =
    zio.aws.ec2.model.FpgaImage.wrap(buildAwsValue())
}
object FpgaImage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FpgaImage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaImage = zio.aws.ec2.model.FpgaImage(
      fpgaImageId.map(value => value),
      fpgaImageGlobalId.map(value => value),
      name.map(value => value),
      description.map(value => value),
      shellVersion.map(value => value),
      pciId.map(value => value.asEditable),
      state.map(value => value.asEditable),
      createTime.map(value => value),
      updateTime.map(value => value),
      ownerId.map(value => value),
      ownerAlias.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isPublic.map(value => value),
      dataRetentionSupport.map(value => value)
    )
    def fpgaImageId: Option[String]
    def fpgaImageGlobalId: Option[String]
    def name: Option[String]
    def description: Option[String]
    def shellVersion: Option[String]
    def pciId: Option[zio.aws.ec2.model.PciId.ReadOnly]
    def state: Option[zio.aws.ec2.model.FpgaImageState.ReadOnly]
    def createTime: Option[DateTime]
    def updateTime: Option[DateTime]
    def ownerId: Option[String]
    def ownerAlias: Option[String]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def isPublic: Option[Boolean]
    def dataRetentionSupport: Option[Boolean]
    def getFpgaImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageId", fpgaImageId)
    def getFpgaImageGlobalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageGlobalId", fpgaImageGlobalId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getShellVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("shellVersion", shellVersion)
    def getPciId: ZIO[Any, AwsError, zio.aws.ec2.model.PciId.ReadOnly] =
      AwsError.unwrapOptionField("pciId", pciId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateTime", updateTime)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getDataRetentionSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataRetentionSupport", dataRetentionSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImage
  ) extends zio.aws.ec2.model.FpgaImage.ReadOnly {
    override val fpgaImageId: Option[String] =
      scala.Option(impl.fpgaImageId()).map(value => value: String)
    override val fpgaImageGlobalId: Option[String] =
      scala.Option(impl.fpgaImageGlobalId()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val shellVersion: Option[String] =
      scala.Option(impl.shellVersion()).map(value => value: String)
    override val pciId: Option[zio.aws.ec2.model.PciId.ReadOnly] = scala
      .Option(impl.pciId())
      .map(value => zio.aws.ec2.model.PciId.wrap(value))
    override val state: Option[zio.aws.ec2.model.FpgaImageState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.FpgaImageState.wrap(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val updateTime: Option[DateTime] = scala
      .Option(impl.updateTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val ownerAlias: Option[String] =
      scala.Option(impl.ownerAlias()).map(value => value: String)
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val isPublic: Option[Boolean] =
      scala.Option(impl.isPublic()).map(value => value: Boolean)
    override val dataRetentionSupport: Option[Boolean] =
      scala.Option(impl.dataRetentionSupport()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImage
  ): zio.aws.ec2.model.FpgaImage.ReadOnly = new Wrapper(impl)
}
