package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FlowLog(
    creationTime: Option[MillisecondDateTime] = None,
    deliverLogsErrorMessage: Option[String] = None,
    deliverLogsPermissionArn: Option[String] = None,
    deliverLogsStatus: Option[String] = None,
    flowLogId: Option[String] = None,
    flowLogStatus: Option[String] = None,
    logGroupName: Option[String] = None,
    resourceId: Option[String] = None,
    trafficType: Option[zio.aws.ec2.model.TrafficType] = None,
    logDestinationType: Option[zio.aws.ec2.model.LogDestinationType] = None,
    logDestination: Option[String] = None,
    logFormat: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    maxAggregationInterval: Option[Integer] = None,
    destinationOptions: Option[zio.aws.ec2.model.DestinationOptionsResponse] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FlowLog = {
    import FlowLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FlowLog
      .builder()
      .optionallyWith(
        creationTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        deliverLogsErrorMessage.map(value => value: java.lang.String)
      )(_.deliverLogsErrorMessage)
      .optionallyWith(
        deliverLogsPermissionArn.map(value => value: java.lang.String)
      )(_.deliverLogsPermissionArn)
      .optionallyWith(deliverLogsStatus.map(value => value: java.lang.String))(
        _.deliverLogsStatus
      )
      .optionallyWith(flowLogId.map(value => value: java.lang.String))(
        _.flowLogId
      )
      .optionallyWith(flowLogStatus.map(value => value: java.lang.String))(
        _.flowLogStatus
      )
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(trafficType.map(value => value.unwrap))(_.trafficType)
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(logDestination.map(value => value: java.lang.String))(
        _.logDestination
      )
      .optionallyWith(logFormat.map(value => value: java.lang.String))(
        _.logFormat
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        maxAggregationInterval.map(value => value: java.lang.Integer)
      )(_.maxAggregationInterval)
      .optionallyWith(destinationOptions.map(value => value.buildAwsValue()))(
        _.destinationOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FlowLog.ReadOnly =
    zio.aws.ec2.model.FlowLog.wrap(buildAwsValue())
}
object FlowLog {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FlowLog] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FlowLog = zio.aws.ec2.model.FlowLog(
      creationTime.map(value => value),
      deliverLogsErrorMessage.map(value => value),
      deliverLogsPermissionArn.map(value => value),
      deliverLogsStatus.map(value => value),
      flowLogId.map(value => value),
      flowLogStatus.map(value => value),
      logGroupName.map(value => value),
      resourceId.map(value => value),
      trafficType.map(value => value),
      logDestinationType.map(value => value),
      logDestination.map(value => value),
      logFormat.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      maxAggregationInterval.map(value => value),
      destinationOptions.map(value => value.asEditable)
    )
    def creationTime: Option[MillisecondDateTime]
    def deliverLogsErrorMessage: Option[String]
    def deliverLogsPermissionArn: Option[String]
    def deliverLogsStatus: Option[String]
    def flowLogId: Option[String]
    def flowLogStatus: Option[String]
    def logGroupName: Option[String]
    def resourceId: Option[String]
    def trafficType: Option[zio.aws.ec2.model.TrafficType]
    def logDestinationType: Option[zio.aws.ec2.model.LogDestinationType]
    def logDestination: Option[String]
    def logFormat: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def maxAggregationInterval: Option[Integer]
    def destinationOptions
        : Option[zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeliverLogsErrorMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsErrorMessage", deliverLogsErrorMessage)
    def getDeliverLogsPermissionArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsPermissionArn", deliverLogsPermissionArn)
    def getDeliverLogsStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deliverLogsStatus", deliverLogsStatus)
    def getFlowLogId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("flowLogId", flowLogId)
    def getFlowLogStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("flowLogStatus", flowLogStatus)
    def getLogGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getTrafficType: ZIO[Any, AwsError, zio.aws.ec2.model.TrafficType] =
      AwsError.unwrapOptionField("trafficType", trafficType)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logDestination", logDestination)
    def getLogFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMaxAggregationInterval: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxAggregationInterval", maxAggregationInterval)
    def getDestinationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("destinationOptions", destinationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FlowLog
  ) extends zio.aws.ec2.model.FlowLog.ReadOnly {
    override val creationTime: Option[MillisecondDateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val deliverLogsErrorMessage: Option[String] =
      scala.Option(impl.deliverLogsErrorMessage()).map(value => value: String)
    override val deliverLogsPermissionArn: Option[String] =
      scala.Option(impl.deliverLogsPermissionArn()).map(value => value: String)
    override val deliverLogsStatus: Option[String] =
      scala.Option(impl.deliverLogsStatus()).map(value => value: String)
    override val flowLogId: Option[String] =
      scala.Option(impl.flowLogId()).map(value => value: String)
    override val flowLogStatus: Option[String] =
      scala.Option(impl.flowLogStatus()).map(value => value: String)
    override val logGroupName: Option[String] =
      scala.Option(impl.logGroupName()).map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val trafficType: Option[zio.aws.ec2.model.TrafficType] = scala
      .Option(impl.trafficType())
      .map(value => zio.aws.ec2.model.TrafficType.wrap(value))
    override val logDestinationType
        : Option[zio.aws.ec2.model.LogDestinationType] = scala
      .Option(impl.logDestinationType())
      .map(value => zio.aws.ec2.model.LogDestinationType.wrap(value))
    override val logDestination: Option[String] =
      scala.Option(impl.logDestination()).map(value => value: String)
    override val logFormat: Option[String] =
      scala.Option(impl.logFormat()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val maxAggregationInterval: Option[Integer] =
      scala.Option(impl.maxAggregationInterval()).map(value => value: Integer)
    override val destinationOptions
        : Option[zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly] = scala
      .Option(impl.destinationOptions())
      .map(value => zio.aws.ec2.model.DestinationOptionsResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FlowLog
  ): zio.aws.ec2.model.FlowLog.ReadOnly = new Wrapper(impl)
}
