package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnclaveOptions(enabled: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnclaveOptions = {
    import EnclaveOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnclaveOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnclaveOptions.ReadOnly =
    zio.aws.ec2.model.EnclaveOptions.wrap(buildAwsValue())
}
object EnclaveOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnclaveOptions =
      zio.aws.ec2.model.EnclaveOptions(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ) extends zio.aws.ec2.model.EnclaveOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ): zio.aws.ec2.model.EnclaveOptions.ReadOnly = new Wrapper(impl)
}
