package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoreErrorItem(
    snapshotId: Option[String] = None,
    fastSnapshotRestoreStateErrors: Option[
      Iterable[zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem = {
    import EnableFastSnapshotRestoreErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastSnapshotRestoreStateErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoreErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem =
      zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem(
        snapshotId.map(value => value),
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotId: Option[String]
    def fastSnapshotRestoreStateErrors: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getFastSnapshotRestoreStateErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fastSnapshotRestoreStateErrors",
      fastSnapshotRestoreStateErrors
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val fastSnapshotRestoreStateErrors: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ] = scala
      .Option(impl.fastSnapshotRestoreStateErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem
  ): zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly =
    new Wrapper(impl)
}
