package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticGpus(
    elasticGpuId: Option[String] = None,
    availabilityZone: Option[String] = None,
    elasticGpuType: Option[String] = None,
    elasticGpuHealth: Option[zio.aws.ec2.model.ElasticGpuHealth] = None,
    elasticGpuState: Option[zio.aws.ec2.model.ElasticGpuState] = None,
    instanceId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ElasticGpus = {
    import ElasticGpus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticGpus
      .builder()
      .optionallyWith(elasticGpuId.map(value => value: java.lang.String))(
        _.elasticGpuId
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(elasticGpuType.map(value => value: java.lang.String))(
        _.elasticGpuType
      )
      .optionallyWith(elasticGpuHealth.map(value => value.buildAwsValue()))(
        _.elasticGpuHealth
      )
      .optionallyWith(elasticGpuState.map(value => value.unwrap))(
        _.elasticGpuState
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ElasticGpus.ReadOnly =
    zio.aws.ec2.model.ElasticGpus.wrap(buildAwsValue())
}
object ElasticGpus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ElasticGpus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticGpus =
      zio.aws.ec2.model.ElasticGpus(
        elasticGpuId.map(value => value),
        availabilityZone.map(value => value),
        elasticGpuType.map(value => value),
        elasticGpuHealth.map(value => value.asEditable),
        elasticGpuState.map(value => value),
        instanceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def elasticGpuId: Option[String]
    def availabilityZone: Option[String]
    def elasticGpuType: Option[String]
    def elasticGpuHealth: Option[zio.aws.ec2.model.ElasticGpuHealth.ReadOnly]
    def elasticGpuState: Option[zio.aws.ec2.model.ElasticGpuState]
    def instanceId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getElasticGpuId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticGpuId", elasticGpuId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getElasticGpuType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticGpuType", elasticGpuType)
    def getElasticGpuHealth
        : ZIO[Any, AwsError, zio.aws.ec2.model.ElasticGpuHealth.ReadOnly] =
      AwsError.unwrapOptionField("elasticGpuHealth", elasticGpuHealth)
    def getElasticGpuState
        : ZIO[Any, AwsError, zio.aws.ec2.model.ElasticGpuState] =
      AwsError.unwrapOptionField("elasticGpuState", elasticGpuState)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpus
  ) extends zio.aws.ec2.model.ElasticGpus.ReadOnly {
    override val elasticGpuId: Option[String] =
      scala.Option(impl.elasticGpuId()).map(value => value: String)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val elasticGpuType: Option[String] =
      scala.Option(impl.elasticGpuType()).map(value => value: String)
    override val elasticGpuHealth
        : Option[zio.aws.ec2.model.ElasticGpuHealth.ReadOnly] = scala
      .Option(impl.elasticGpuHealth())
      .map(value => zio.aws.ec2.model.ElasticGpuHealth.wrap(value))
    override val elasticGpuState: Option[zio.aws.ec2.model.ElasticGpuState] =
      scala
        .Option(impl.elasticGpuState())
        .map(value => zio.aws.ec2.model.ElasticGpuState.wrap(value))
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpus
  ): zio.aws.ec2.model.ElasticGpus.ReadOnly = new Wrapper(impl)
}
