package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateTrunkInterfaceResponse(
    returnValue: Option[Boolean] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse = {
    import DisassociateTrunkInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.wrap(buildAwsValue())
}
object DisassociateTrunkInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateTrunkInterfaceResponse =
      zio.aws.ec2.model.DisassociateTrunkInterfaceResponse(
        returnValue.map(value => value),
        clientToken.map(value => value)
      )
    def returnValue: Option[Boolean]
    def clientToken: Option[String]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse
  ) extends zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse
  ): zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
