package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VolumeId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVolumeStatusRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    volumeIds: Option[Iterable[VolumeId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest = {
    import DescribeVolumeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumeStatusRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumeStatusRequest.wrap(buildAwsValue())
}
object DescribeVolumeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumeStatusRequest =
      zio.aws.ec2.model.DescribeVolumeStatusRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        volumeIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def volumeIds: Option[List[VolumeId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest
  ) extends zio.aws.ec2.model.DescribeVolumeStatusRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val volumeIds: Option[List[VolumeId]] = scala
      .Option(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VolumeId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest
  ): zio.aws.ec2.model.DescribeVolumeStatusRequest.ReadOnly = new Wrapper(impl)
}
